// // // // // // // // // // // // // // // // // // // //
//	
//	Basic Window
//	
//	created Apr/12/98 by Andreas Warnke
//	last mod Apr/21/98 by Andreas Warnke
//	



// // // // // // // // // // // // // // // // // // // //
//	
//	include
//

#include <Be.h>
#include "BasicWindow.h"
#include "GlobalVariables.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Constructor
//

BasicWindow :: BasicWindow () : BWindow (
	GetStartupRect (),
	"Enemy Territory Basic Agent",
	B_TITLED_WINDOW,
	B_NOT_RESIZABLE | B_NOT_ZOOMABLE /*| B_NOT_MINIMIZABLE */)
{
	//	Login Button:
	TheLogin = new BButton (
		BRect ( 250, 60, 349, 79 ),
		"Login Button",
		"Login",
		new BMessage ( eLoginButtonPressed ) );
	if ( TheLogin != NULL )
	{
		TheLogin -> SetTarget ( this );
		AddChild ( TheLogin );
		SetDefaultButton ( TheLogin );
	};

	//	Name - TextControl:
	TheName = new BTextControl (
		BRect ( 0, 20, 299, 49 ),
		"Name Input",
		"Name:",
		"Basic Agent",
		NULL );
	if ( TheName != NULL )
	{
		TheName -> SetDivider (100.0);
		TheName -> SetAlignment ( B_ALIGN_RIGHT, B_ALIGN_LEFT );
		AddChild ( TheName );
		TheName -> MakeFocus ( true );
	};

	//	About - Stringview
	BStringView * sAbout = new BStringView (
		BRect( 10, 70, 249, 89 ),
		"About StringView",
		"developed by Andreas Warnke"
	);
	if ( sAbout != NULL )
		AddChild ( sAbout ); 
		
	//	Background:
	BView * sView = new BView (
		Bounds(),
		"Background View",
		B_FOLLOW_ALL_SIDES,
		B_WILL_DRAW );
	if ( sView != NULL )
	{
		sView -> SetViewColor ( 0xbb, 0xee, 0xdd );
		AddChild ( sView );
	};

	//	Show:
	Show ();
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Destructor
//

BasicWindow :: ~BasicWindow ()
{
	//	Nothing to do.
};



// // // // // // // // // // // // // // // // // // // //
//	
//	QuitRequested
//

bool BasicWindow :: QuitRequested ()
{
	//	Tell application to quit:
	be_app -> PostMessage ( B_QUIT_REQUESTED );
	
	//	Close the window:
	return true;
};



// // // // // // // // // // // // // // // // // // // //
//	
//	GetStartupRect
//

BRect BasicWindow :: GetStartupRect ()
{
	return BRect ( 200, 30, 599, 129 );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	MessageReceived
//

void BasicWindow :: MessageReceived ( BMessage * inMessage )
{
	if ( inMessage -> what == eLoginButtonPressed )
	{
		//	Login Button was pressed.
		//	Add Login-Name to Message:
		if ( TheName != NULL )
			inMessage -> AddString ( "Name", TheName -> Text () );
		//	Add Login-Password to Message:
		inMessage -> AddString ( "Password", GenerateRandomString () );
		
		//	Forward this Message to the Agent:
		BMessenger ( NULL, TheSimpleReflexAgent ) . SendMessage ( inMessage );
		
		//	Disable the controls:
		if ( TheName != NULL )
			TheName -> SetEnabled ( false );
		if ( TheLogin != NULL )
			TheLogin -> SetEnabled ( false );
	}
	else
		//	unknown message.
		//	ask daddy:
		BWindow :: MessageReceived ( inMessage );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Random ASCII Password genertator
//

char * BasicWindow :: GenerateRandomString ( unsigned int inLength )
{
	char * sReturnValue = new char [ inLength + 1 ];
	if ( sReturnValue != NULL )
	{
		//	String exists.
		
		for ( int i = 0; i < inLength; i++ )
			//	Generate i-th character:
			sReturnValue [ i ] = Fate . GetLong ( 128 - 32 ) + 32;
			
		//	0-Terminator:
		sReturnValue [ inLength ] = 0;
	};
	
	//	ready:
	return sReturnValue;
};



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //

